import os
import json


def main():
    """
    Main function to finalize questions by loading derived questions
    and saving them without generating LLM answers.
    """

    # Load the quantitative data derived by pre_answer_question.py
    try:
        with open("derived_quantitative_questions.json", 'r', encoding='utf-8') as f:
            derived_questions = json.load(f)
    except FileNotFoundError:
        print("Error: derived_quantitative_questions.json not found. Please run pre_answer_question.py first.")
        return

    final_questions = []
    for i, item in enumerate(derived_questions):
        print(f"--- Processing question {i+1}/{len(derived_questions)} ---")

        record = {
            "open_question": item['open_question'],
            "derived_quantitative_question": item['derived_quantitative_question'],
            "derived_quantitative_answer": item['derived_quantitative_answer'],
            "reference_answer": item['original_open_answer']  # For comparison/evaluation
        }
        final_questions.append(record)

    # Save the final questions
    output_file = "final_questions.json"
    with open(output_file, 'w', encoding='utf-8') as f:
        json.dump(final_questions, f, ensure_ascii=False, indent=4)

    print(f"\nSuccessfully processed {len(final_questions)} questions.")
    print(f"Output saved to {output_file}")


if __name__ == "__main__":
    main()