"""
Training utilities for GLEAM-AI.

This module provides training loops, callbacks, and other utilities
for training the STNP model.
"""

from .trainer import GLEAMTrainer
from .callbacks import ActiveLearningCallback, ModelCheckpointCallback, MetricsLoggerCallback, EarlyStoppingCallback
from .utils import (
    load_training_config, setup_training_environment, create_experiment_setup,
    validate_training_config, setup_logging, save_training_summary,
    load_training_results, compare_experiments, create_training_script
)
from .main import main, run_standard_training, run_active_learning_training
from .legacy_trainer import run_legacy_training, create_legacy_run_script

__all__ = [
    # Main trainer
    "GLEAMTrainer",
    
    # Callbacks
    "ActiveLearningCallback",
    "ModelCheckpointCallback", 
    "MetricsLoggerCallback",
    "EarlyStoppingCallback",
    
    # Utilities
    "load_training_config",
    "setup_training_environment",
    "create_experiment_setup",
    "validate_training_config",
    "setup_logging",
    "save_training_summary",
    "load_training_results",
    "compare_experiments",
    "create_training_script",
    
    # Main functions
    "main",
    "run_standard_training",
    "run_active_learning_training",
    
    # Legacy support
    "run_legacy_training",
    "create_legacy_run_script"
]
