import json
from eval.dipper import DipperParaphraser
import os
def load_json(file_path):
    """加载 JSON 文件"""
    with open(file_path, 'r', encoding='utf-8') as f:
        return json.load(f)

def collect_data(output_dir):
    result = {}
    for file_path in output_dir:
        data = load_json(file_path)


        filename = os.path.basename(file_path)  
        identifier = filename.split('_')[-1].replace('.json', '') 


        result[identifier] = {
            'our_wm_output': data.get('our_wm_output'),
            'our_wm_output1': data.get('our_wm_output1'),
            'kgw_wm_output': data.get('kgw_wm_output')
        }

    return result



output_dir = [
    "./LTW/eval_records/eval_plot/outputs_d1.json",
    "./LTW/eval_records/eval_plot/outputs_d1.25.json",
    "./LTW/eval_records/eval_plot/outputs_d1.5.json",
    "./LTW/eval_records/eval_plot/outputs_d2.5.json",
    './LTW/eval_records/eval_plot/outputs_d3.json',
    "./LTW/eval_records/eval_plot/outputs_d3.5.json"
]




data_dict = collect_data(output_dir)


output_path = "./LTW/eval_records/eval_plot/outputs.json"
try:
    with open(output_path, 'w', encoding='utf-8') as f:
        json.dump(data_dict, f, ensure_ascii=False, indent=4)
        print(f"保存 成功")   
except Exception as e:
    print(f"保存 JSON 失败: {e}")


    
import torch
import os
import json
from datasets import load_dataset, Dataset


os.environ["CUDA_VISIBLE_DEVICES"] = "4,5,6"
hash_key = 15485863
torch.manual_seed(hash_key)
device = torch.device('cuda' if torch.cuda.is_available() else 'cpu')

dp = DipperParaphraser()


dataset = load_dataset("json", data_files="./LTW/c4_subset_500.jsonl")["train"]


dipper_output = {}
for key in data_dict:
    dipper_output[key] = {
        'our_wm_output': [],
        'our_wm_output1': [],
        'kgw_wm_output': []
    }

print("start dipper attack")
count = 0
for data in dataset:
    prompt = data['text'][:300]
    for key in data_dict:
        original_entry = data_dict[key]

 
        for field in ['our_wm_output', 'our_wm_output1', 'kgw_wm_output']:
            original_text = original_entry[field][count]
            paraphrased = dp.paraphrase(original_text,
                                         lex_diversity=60,
                                         order_diversity=0,
                                         prefix=prompt,
                                         do_sample=True,
                                         top_p=0.75,
                                         top_k=None,
                                         max_length=300)
            dipper_output[key][field].append(paraphrased)
    count += 1


output_para_path = "./LTW/eval_records/eval_plot/dipper_attack_output.json"
try:
    with open(output_para_path, 'w', encoding='utf-8') as f:
        json.dump(dipper_output, f, ensure_ascii=False, indent=4)
        print("保存成功")
except Exception as e:
    print(f"保存 JSON 失败: {e}")
