
#ifndef IMAGES_H_INCLUDED
#define IMAGES_H_INCLUDED

#include <vector>

#include "approximation.h"
#include "utilities.h"
namespace Gudhi::mma::representation{


using Gudhi::mma::boundary_matrix;
using Gudhi::mma::filtration_type;
using Gudhi::mma::dimension_type;
using Gudhi::mma::Module;
using Gudhi::mma::Box;

struct ImageArgs{
private:
	unsigned int module_dim;				// number of persistent parameters.	
public:
	std::vector<unsigned int> resolution;	// resolution of the image
	double p;								// sum smoothing
	bool normalize;							// Enforce image to take values in [0,1]
	int dimension;							// if negative -> all dim
	Box box;								// Possible sub-box.
};



std::vector<std::vector<std::vector<double> > > get_2D_image_from_boundary_matrix(
		boundary_matrix &boundaryMatrix,
		std::vector<filtration_type> &filtersList,
		const double precision,
		const Box &box,
		const double delta,
		const double p,
		const bool normalize, 
		const std::vector<unsigned int> &resolution,
		const dimension_type dimension,
		const bool complete = true,
		const bool verbose = false)
{
	Box bbox(box);
	bbox.inflate(delta);
	Module approximation =
			Gudhi::mma::compute_vineyard_barcode_approximation(
				boundaryMatrix,
				filtersList,
				precision,
				bbox,
				true,
				complete,
				false,
				verbose);

	if (dimension < 0)
		return approximation.get_vectorization(delta, p, normalize, resolution[0], resolution[1]);

	return {approximation.get_vectorization_in_dimension(dimension, delta, p, normalize,  resolution[0], resolution[1])};
}

} //namespace

#endif // IMAGES_H_INCLUDED
