// ContextMenu.java

package net.sf.gogui.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.sf.gogui.game.MarkType;
import net.sf.gogui.go.GoPoint;
import static net.sf.gogui.gui.I18n.i18n;

/** Context menu for fields on board. */
public class ContextMenu
    extends JPopupMenu
{
    /** Callback for events generated by ContextMenu. */
    public interface Listener
    {
        void actionEditLabel(GoPoint point);

        void actionMark(GoPoint point, MarkType type, boolean mark);
    }

    public ContextMenu(GoPoint point, boolean mark, boolean markCircle,
                       boolean markSquare, boolean markTriangle,
                       Listener listener)
    {
        m_point = point;
        m_listener = listener;
        m_actionListener = new ActionListener()
            {
                public void actionPerformed(ActionEvent event)
                {
                    Listener listener = ContextMenu.this.m_listener;
                    if (listener == null)
                        return;
                    String actionCommand = event.getActionCommand();
                    if (actionCommand.equals("cancel"))
                    {
                        ContextMenu.this.setVisible(false);
                    }
                    else if (actionCommand.equals("mark"))
                    {
                        boolean mark
                            = ContextMenu.this.m_mark.isSelected();
                        listener.actionMark(m_point, MarkType.MARK, mark);
                    }
                    else if (actionCommand.equals("mark-circle"))
                    {
                        boolean mark
                            = ContextMenu.this.m_markCircle.isSelected();
                        listener.actionMark(m_point, MarkType.CIRCLE, mark);
                    }
                    else if (actionCommand.equals("mark-square"))
                    {
                        boolean mark
                            = ContextMenu.this.m_markSquare.isSelected();
                        listener.actionMark(m_point, MarkType.SQUARE, mark);
                    }
                    else if (actionCommand.equals("mark-triangle"))
                    {
                        boolean mark
                            = ContextMenu.this.m_markTriangle.isSelected();
                        listener.actionMark(m_point, MarkType.TRIANGLE, mark);
                    }
                    else if (actionCommand.equals("edit-label"))
                    {
                        listener.actionEditLabel(m_point);
                    }
                }
            };
        setLabel(MessageFormat.format(i18n("LB_CONTEXTMENU_POINT"), point));
        m_mark = createCheckBox("MN_CONTEXTMENU_MARK", "mark");
        m_mark.setSelected(mark);
        add(m_mark);
        m_markCircle = createCheckBox("MN_CONTEXTMENU_MARK_CIRCLE",
                                      "mark-circle");
        m_markCircle.setSelected(markCircle);
        add(m_markCircle);
        m_markSquare = createCheckBox("MN_CONTEXTMENU_MARK_SQUARE",
                                      "mark-square");
        m_markSquare.setSelected(markSquare);
        add(m_markSquare);
        m_markTriangle = createCheckBox("MN_CONTEXTMENU_MARK_TRIANGLE",
                                        "mark-triangle");
        m_markTriangle.setSelected(markTriangle);
        add(m_markTriangle);
        add(createItem("MN_CONTEXTMENU_EDIT_LABEL", "edit-label"));
        addSeparator();
        add(createItem("LB_CANCEL", "cancel"));
    }

    public GoPoint getPointArg()
    {
        return m_point;
    }

    private final ActionListener m_actionListener;

    private final GoPoint m_point;

    private final JCheckBoxMenuItem m_mark;

    private final JCheckBoxMenuItem m_markCircle;

    private final JCheckBoxMenuItem m_markSquare;

    private final JCheckBoxMenuItem m_markTriangle;

    private final Listener m_listener;

    private JCheckBoxMenuItem createCheckBox(String label,
                                             String actionCommand)
    {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(i18n(label));
        item.addActionListener(m_actionListener);
        item.setActionCommand(actionCommand);
        return item;
    }

    private JMenuItem createItem(String label, String actionCommand)
    {
        JMenuItem item = new JMenuItem(i18n(label));
        item.addActionListener(m_actionListener);
        item.setActionCommand(actionCommand);
        return item;
    }
}
