import abc
from abc import ABC

from torch import Tensor

from utils.dynamically_load_class import Configurable


class Algorithm(Configurable, ABC):
    ALGORITHM_NAME: str = None

    @abc.abstractmethod
    def train(self, **kwargs):
        raise NotImplementedError()

    @abc.abstractmethod
    def set_start_point(self, start_point: Tensor):
        raise NotImplementedError()
