from typing import Protocol, runtime_checkable

from algorithms.convergence_algorithms.typing import BoundedEvaluatedSamplerIdentifiableSpace


@runtime_checkable
class ConversionAlgorithm(Protocol):
    @property
    def best_point_until_now(self):
        raise NotImplementedError()


@runtime_checkable
class AlgorithmOnEnvironment(ConversionAlgorithm, Protocol):
    @property
    def environment(self) -> BoundedEvaluatedSamplerIdentifiableSpace:
        raise NotImplementedError()
