from abc import ABC
from typing import Protocol, Sized

from torch.utils.data import Dataset

from algorithms.space.base_space import (
    BoundedSpace,
    EvaluatedSpace,
    SamplerSpace,
    BudgetLimitedSpace,
    IdentifiableSpace,
)


class SamplerEvaluatedSpace(SamplerSpace, EvaluatedSpace, Protocol):
    pass


class BoundedSamplerSpace(BoundedSpace, SamplerSpace, Protocol):
    pass


class BoundedEvaluatedSpace(BoundedSpace, EvaluatedSpace, Protocol):
    pass


class BoundedEvaluatedSamplerSpace(
    BoundedSpace, SamplerSpace, EvaluatedSpace, BudgetLimitedSpace, Protocol
):
    pass


class BoundedEvaluatedSamplerIdentifiableSpace(
    BudgetLimitedSpace,
    SamplerSpace,
    EvaluatedSpace,
    BoundedSpace,
    IdentifiableSpace,
    Protocol,
):
    pass


class SizedDataset(Dataset, Sized, ABC):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
