import math


def sqrt_dim_multiplier(node, dependencies):
    dimension = dependencies.pop("dimension")
    epsilon_base = dependencies.pop("multiplier_base", 0.1)
    return math.sqrt(dimension) * epsilon_base


def sqrt_dim_multiplier_floor(node, dependencies):
    return math.floor(sqrt_dim_multiplier(node, dependencies))


def sqrt_dim_multiplier_ceil(node, dependencies):
    return math.ceil(sqrt_dim_multiplier(node, dependencies))


def logger_creator(node, dependencies, logger):
    return logger


def create_cma(node, dependencies):
    return node.type.from_space(
        dependencies["env"], None, dependencies["input_mapping"], dependencies["logger"]
    )


def empty_creator(*args, **kwargs):
    return None
