import torch
from torch import Tensor


def gram_schmidt(vectors):
    basis = []
    for v in vectors:
        for u in basis:
            v -= torch.dot(v, u) / torch.dot(u, u) * u
        basis += [v / torch.norm(v)]
    return torch.stack(basis)


def create_gram_schmidt(vector: Tensor, device: int) -> Tensor:
    basis = torch.rand((len(vector) - 1, len(vector))).to(device=device)
    return gram_schmidt(torch.cat([vector.unsqueeze(0), basis]))
