class MultiOptimizer:
    def __init__(self, *optimizers):
        self.optimizers = optimizers

    def zero_grad(self):
        for optimizer in self.optimizers:
            optimizer.zero_grad()

    def step(self):
        for optimizer in self.optimizers:
            optimizer.step()


def create_opt(node, dependencies):
    module = dependencies.pop("model")
    return node.type(module.parameters(), **dependencies)
