from typing import Union

import numpy as np
from cocoex import Suite
from cocoex.exceptions import NoSuchProblemException
from torch import Tensor

COCO_SUITE = Suite("bbob", "", "")
HIGH_DIM_COCO_SUITE = Suite("bbob-largescale", "", "")


def is_multiple_points(data: Union[Tensor, np.ndarray]) -> bool:
    return len(data.shape) == 2


def coco_problem_from_index(index: int):
    return COCO_SUITE[index]


def coco_largescale_problem_from_index(index: int):
    return HIGH_DIM_COCO_SUITE[index]


def coco_problem_from_funcnum_and_dim(func_num: int, dim: int, instance: int):
    benchmark = COCO_SUITE
    try:
        return benchmark.get_problem_by_function_dimension_instance(
            func_num, dim, instance
        )
    except NoSuchProblemException:
        benchmark = HIGH_DIM_COCO_SUITE
        return benchmark.get_problem_by_function_dimension_instance(
            func_num, dim, instance
        )


def best_k_by_values(data: Tensor, values: Tensor, k: int) -> Tensor:
    top_k_new_x_opt_indices = (-values).topk(k, sorted=True).indices
    return data[top_k_new_x_opt_indices].clone()
