from algorithms.stopping_condition.base import AlgorithmStopCondition


class TrustRegionStopCondition(AlgorithmStopCondition):
    REASON = "{alg} reached trust region too small {tr}"

    def should_stop(self, alg, **kwargs) -> bool:
        if getattr(alg, "input_mapping", None) is None:
            return False
        return alg.input_mapping.stop_condition()


class StopAfterXTimes(AlgorithmStopCondition):
    REASON = "{alg} stop after x times in {best_point}"

    def __init__(self, max_number_of_shrinks: int):
        self.max_number_of_shrinks = max_number_of_shrinks

    def should_stop(self, alg, counter: int = None, **kwargs) -> bool:
        return counter is not None and counter >= self.max_number_of_shrinks
