import torch
import transformers
from transformers import AutoTokenizer

model = "codellama/CodeLlama-7b-Instruct-hf"


run_code = """
import random
def is_sorted(data):
    return all(data[i] <= data[i+1] for i in range(len(data) - 1))

def bogosort(data):
    attempts = 0
    while not is_sorted(data):
        random.shuffle(data)
        attempts += 1
    return data, attempts
"""

def main():
    tokenizer = AutoTokenizer.from_pretrained(model)
    pipeline = transformers.pipeline(
        "text-generation",
        model=model,
        torch_dtype=torch.float16,
        device_map="auto",
    )

    sequences = pipeline(
        f"Here is my code: {run_code},"
        f"I want you to generate a code with the same results which optimize cpu time as much as possible.",
        do_sample=True,
        top_k=10,
        temperature=0.1,
        top_p=0.95,
        num_return_sequences=1,
        eos_token_id=tokenizer.eos_token_id,
        max_length=200,
    )
    for seq in sequences:
        print(f"Result: {seq['generated_text']}")


if __name__ == '__main__':
    main()