DR_FUNC_NAME = "count_triplets"
DR_FUNC = f"""
from typing import List, Tuple
def {DR_FUNC_NAME}(n: int, x: int) -> int:
    \"\"\"
    This function calculates the number of triplets (a, b, c) of positive integers such that:
    1. a*b + a*c + b*c ≤ n
    2. a + b + c ≤ x
    where the order of triplets matters (e.g., (1, 1, 2) and (1, 2, 1) are different triplets) 
    and a, b, c must be strictly greater than 0.
    
    Parameters:
    n (int): An integer representing the upper limit for the sum of the product pairs.
    x (int): An integer representing the upper limit for the sum of the triplet elements.
    
    Returns:
    int: The number of valid triplets (a, b, c) that satisfy the given conditions.
    
    Constraints:
    - n and x are positive integers.
    - The function should efficiently count the number of valid triplets considering the constraints.
    
    Example:
    count_triplets(10, 5) -> 3
    Explanation: The valid triplets are (1,1,1), (1,1,2), and (1,2,1).
    \"\"\"
"""


DR_FUNC_EXPECTED_OUTPUT = {
    (7, 4): 4,
    (10, 5): 10,
    (7, 1000): 7,
    # (900000, 400000): 1768016938,
}
