LAST_ADD_MIN_FUNC_NAME = "minimize_last_number"
LAST_ADD_MIN = f"""
def {LAST_ADD_MIN_FUNC_NAME}(n):
    \"\"\"
    Given an integer `n` representing the numbers from 1 to `n` written on a board,
    this function performs a series of operations to minimize the last remaining
    number on the board.

    Operation Description:
    - In each operation, you can pick any two numbers `a` and `b` from the board.
    - Erase these two numbers.
    - Write the integer `ceil((a + b) / 2)` on the board instead (where `ceil`
      represents rounding up to the nearest integer).

    The function aims to perform this operation `n - 1` times such that the 
    remaining single number on the board is as small as possible.

    Parameters:
    - n (int): The number of integers initially written on the board (from 1 to `n`).

    Returns:
    - tuple: A tuple where:
      - The first element is the minimum possible number left on the board.
      - The second element is a list of tuples representing the operations performed.
        Each tuple contains two integers `a` and `b` which were erased in each
        operation.

    Example:
    For an input of `n = 4`:

    The output will be:
    (2, [(4, 2), (3, 3), (3, 1)])
    This indicates that for `n = 4`, the minimum possible number left on the 
    board is 2, and the sequence of operations performed was (4, 2), (3, 3), and (3, 1).
    \"\"\"
"""


def verify_minimized_number(n, results):
    """
    Verifies whether the given final number and operations are a legitimate output
    for the minimize_last_number task.

    Parameters:
    - n (int): The number of integers initially written on the board (from 1 to `n`).
    - final_number (int): The supposed minimum number left on the board after the operations.
    - operations (list of tuples): A list of tuples representing the operations performed.
      Each tuple contains two integers `a` and `b` which were erased in each operation.

    Returns:
    - bool: True if the final number and operations are valid, False otherwise.
    """
    final_number, operations = results
    # Start with the initial numbers on the board
    board = list(range(1, n + 1))

    for a, b in operations:
        if a not in board or b not in board:
            return 1  # Invalid operation if a or b are not on the board

        board.remove(a)
        board.remove(b)
        new_number = (a + b + 1) // 2
        board.append(new_number)

    # There should be exactly one number left on the board
    if len(board) != 1:
        return 1

    # The remaining number should match the provided final_number
    return 0 if board[0] == final_number else -1


LARGEST_INTEGER = f"""
def find_largest_displayable_integer(n):
    \"\"\"
    Finds the largest integer that can be displayed on a seven-segment screen with a given number of segments.

    The seven-segment screen can display digits from 0 to 9, each digit requiring a different number of segments:
    - 0 -> 6 segments
    - 1 -> 2 segments
    - 2 -> 5 segments
    - 3 -> 5 segments
    - 4 -> 4 segments
    - 5 -> 5 segments
    - 6 -> 6 segments
    - 7 -> 3 segments
    - 8 -> 7 segments
    - 9 -> 6 segments

    The function should find the largest integer possible by turning on no more than `n` segments.
    If `n` is odd, the function starts with a '7' (3 segments) and uses as many '1's (2 segments each) as possible
    with the remaining segments. If `n` is even, the function uses '1's for all segments.

    Parameters:
    n (int): The maximum number of segments that can be turned on (2 ≤ n ≤ 10^5).

    Returns:
    str: The largest integer that can be displayed with the given number of segments.

    Example:
    >>> find_largest_displayable_integer(3)
    7
    
    >>> find_largest_displayable_integer(15)
    7111111
    \"\"\"
"""

LARGEST_INT_PARAMS = {
    3: "7",
    15: "7111111",
    20: "7111111111",
}
