from aenum import Enum

from compute_result.result_store.file_storage import FileStorage
from compute_result.result_store.sql_hierarchy import SQLHierarchyStorage
from compute_result.result_store.sql_lite_storage import SQLiteStorage


class StoreTypes(Enum):
    SQLITE = "sqlite"
    SQLITE_HIERARCHY = "sqlite_hier"
    FILE = "file"


class StoreFactory:
    @staticmethod
    def get_store(store_type: StoreTypes = StoreTypes.SQLITE_HIERARCHY, **kwargs):
        if store_type == StoreTypes.SQLITE:
            return SQLiteStorage(**kwargs)
        elif store_type == StoreTypes.SQLITE_HIERARCHY:
            return SQLHierarchyStorage(**kwargs)
        else:
            return FileStorage(**kwargs)
