import dataclasses
from typing import Tuple, List, Any, Callable

from aenum import Enum

from problems.types import Suites
from utils.algorithms_data import Algorithms

Run = Tuple[Algorithms, str]
RunWithPlotName = Tuple[Algorithms, str, str]
ProblemSpace = Tuple[Suites, int, int, int]  # suite, func number, dim, instance
Point = List[float]
ResultRow = Tuple[int, float, Point, str]  # budget, value, point, algorithm name
RunResult = List[ResultRow]
BudgetRun = List[Tuple[int, float]]  # budget, value
BudgetStepsRun = List[Tuple[int, Any]]  # budget, value


class StatisticalAnalysisOptions(Enum):
    MEAN = "mean"
    MEDIAN = "median"
    QUANTILE_90 = "quantile_90"
    QUANTILE_10 = "quantile_10"
    STD = "std"
    FULL = "full"


class MetricManipulation(Enum):
    NONE = "none"
    NORM = "norm"
    NORM_CUMSUM = "norm_cumsum"
    COS = "cos"
    COS_CUMSUM = "cos_cumsum"


class AxisAnalysis(Enum):
    MEAN = "mean"
    STD = "std"
    SOLVED = "solved"
    BUDGET_FOR_PROGRESS = "budget_for_progress"


@dataclasses.dataclass
class AxisAnalysisData:
    analyze: Callable
    name: Callable
