from aenum import Enum

import algorithms
from algorithms.convergence_algorithms.base import Algorithm
from utils.dynamically_load_class import find_subclasses, get_signature_parameters

algorithms_types = find_subclasses(algorithms, Algorithm)
algorithms_map = {alg_type.ALGORITHM_NAME: alg_type for alg_type in algorithms_types}

algorithm_constructor_params = {
    algorithm.ALGORITHM_NAME: get_signature_parameters(algorithm, algorithm, Algorithm)
    for algorithm in algorithms_types
}
algorithm_train_params = {
    algorithm.ALGORITHM_NAME: get_signature_parameters(
        getattr(algorithm, Algorithm.train.__name__), algorithm, Algorithm
    )
    for algorithm in algorithms_types
}

Algorithms = Enum(
    "Algorithms", {alg_name.upper(): alg_name for alg_name in algorithms_map.keys() if alg_name}
)
