from typing import Callable


class ConfigValue:
    def __call__(self, *args, **kwargs):
        raise NotImplementedError()


class FuncConfig(ConfigValue):
    def __init__(self, func: Callable):
        self.func = func

    def __call__(self, *args, **kwargs):
        return self.func(*args, **kwargs)
