import torch


def hessian_from_gradient_network(grad_network, x):
    jacobian = (
        torch.vmap(torch.func.jacrev(grad_network), randomness="different")
        if len(x.shape) == 2
        else torch.func.jacrev(grad_network)
    )
    j = jacobian(x)
    return (j + j.transpose(-2, -1)) / 2
