import abc
from abc import ABC

from utils.dynamically_load_class import Configurable


class ParamScheduler(Configurable, ABC):
    @property
    @abc.abstractmethod
    def value(self):
        pass

    @abc.abstractmethod
    def step(self, **kwargs):
        pass


class ConstantScheduler(ParamScheduler):
    def __init__(self, scheduler_value: int):
        self.scheduler_value = scheduler_value

    @property
    def value(self):
        return self.scheduler_value

    def step(self, **kwargs):
        pass


class BudgetLimitScheduler(ParamScheduler):
    def __init__(self, initial_value: int, budget_limit: int, last_value):
        self.initial_value = initial_value
        self.current_value = initial_value
        self.budget_limit = budget_limit
        self.last_value = last_value

    @property
    def value(self):
        return self.current_value

    def step(self, alg, **kwargs):
        if alg.env.used_budget > self.budget_limit:
            self.current_value = self.last_value
