import torch


def cartesian_to_hyperspherical(tensor):
    # Calculate the radial distance (radius)
    radius = tensor.norm(dim=-1)

    # Calculate the angles
    angles = []
    for i in range(tensor.size(-1) - 1, 0, -1):
        angle = torch.atan2(tensor[..., i:].norm(dim=-1), tensor[..., i - 1])
        angles.insert(0, angle)  # Insert at the beginning to keep the order

    # Combine radius and angles into a hyperspherical coordinates tensor
    hyperspherical_coordinates = torch.stack([radius] + angles, dim=-1)

    return hyperspherical_coordinates


def hyperspherical_to_cartesian(hyperspherical):
    # Extract radius and angles
    radius = hyperspherical[..., 0]
    angles = hyperspherical[..., 1:]

    # Initialize tensor for Cartesian coordinates
    tensor = torch.empty_like(hyperspherical)

    # Compute Cartesian coordinates
    tensor[..., 0] = radius * torch.cos(angles[..., 0])
    for i in range(1, angles.size(-1)):
        tensor[..., i] = (
            radius * torch.prod(torch.sin(angles[..., :i]), dim=-1) * torch.cos(angles[..., i])
        )
    tensor[..., -1] = radius * torch.prod(torch.sin(angles), dim=-1)

    return tensor
