from algorithms.convergence_algorithms.protocols import AlgorithmOnEnvironment
from algorithms.stopping_condition.base import AlgorithmStopCondition


class EarlyBudgetStop(AlgorithmStopCondition):
    REASON = "{alg} Have exceeded budget"

    def __init__(self, max_budget: int):
        self.max_budget = max_budget

    def should_stop(self, alg: AlgorithmOnEnvironment, **kwargs) -> bool:
        if alg.environment.used_budget > self.max_budget:
            return True
        return False
