from pathlib import Path

from PIL import Image
from datasets import load_dataset


def dataset_from_datasets_package(name: str, size: int, split: str = "validation"):
    dataset = load_dataset(name, split=split, streaming=True)
    dataset_iter = iter(dataset)
    images = [next(dataset_iter) for _ in range(size)]
    return [(image["image"], image["label"]) for image in images]


def images_from_folder(path: str):
    path = Path(path)
    images = [
        (Image.open(image_path), int(image_path.stem.split("_")[-1]))
        for image_path in path.iterdir()
    ]
    return images
