from aenum import Enum
from OptimizationTestFunctions import (
    Michalewicz,
    SchwefelSin,
    Weierstrass,
    Sphere,
    Rastrigin,
    Ackley,
    Rosenbrock,
    Fletcher,
    Griewank,
    Penalty2,
    Quartic,
    SchwefelDouble,
    SchwefelMax,
    Stairs,
    Abs,
    Scheffer,
    Eggholder,
    AckleyTest,
)


PYTHONIC_SUITE = [
    Sphere,
    Ackley,
    Rosenbrock,
    Fletcher,
    Griewank,
    Penalty2,
    Quartic,
    Rastrigin,
    SchwefelDouble,
    SchwefelMax,
    AckleyTest,
    SchwefelSin,
    Stairs,
    Abs,
    Michalewicz,
    Scheffer,
    Eggholder,
    Weierstrass,
]


class Suites(Enum):
    COCO = "coco"
    PYTHONIC = "pythonic"
    EXTERNAL = "external"


class Benchmarks(Enum):
    TEST = "test"
    COCO = "coco"
    COCO_HIGH_DIM = "coco_high_dim"
    PARTIAL_COCO_HIGH_DIM = "par_coco_high_dim"
    PARTIAL_COCO_HIGH_DIM_2 = "par_coco_high_dim_2"
    PARTIAL_COCO = "par_coco"
    PARTIAL_COCO_40 = "par_coco_40"
    PAR_COCO_LOW = "par_coco_low"
    OPT_GAN = "opt_gan"
    HIGH_DIM = "high_dim"
    LOCAL_COCO = "local_coco"
    PAR_UNSOLVED = "par_unsolved"
    SIMPLE_UNSOLVED = "sim_unsolved"
    HIGH_UNSOLVED = "high_unsolved"
