import torch

from algorithms.space.base_space import BoundedSpace
from algorithms.space.callable_function import CallableSpace
from algorithms.space.coco import CocoSpace
from algorithms.space.utils import (
    coco_problem_from_index,
    coco_largescale_problem_from_index,
    coco_problem_from_funcnum_and_dim,
)
from problems.types import PYTHONIC_SUITE

BUDGET = 150_000


def coco_space_from_index(index: int, budget: int = BUDGET) -> CocoSpace:
    return CocoSpace(coco_problem_from_index(index), budget)


def coco_largescale_space_from_index(index: int, budget: int = BUDGET) -> CocoSpace:
    return CocoSpace(coco_largescale_problem_from_index(index), budget)


def coco_space_from_funcnum_and_dim(
    func_num: int, dim: int, instance: int, budget: int = BUDGET
) -> CocoSpace:
    return CocoSpace(coco_problem_from_funcnum_and_dim(func_num, dim, instance), budget)


def callable_space_from_funcnum_and_dim(
    index: int, dim: int, instance: int, budget: int = BUDGET
):
    return CallableSpace(
        PYTHONIC_SUITE[index](dim),
        torch.tensor([-5] * dim, dtype=torch.float64),
        torch.tensor([5] * dim, dtype=torch.float64),
        budget=budget,
    )

def bounds_from_space(space: BoundedSpace, dim: int):
    return space.lower_bound[dim], space.upper_bound[dim]
