# Effect of omega on the convergence rate

from algorithms import *

plot_only = True

linestyles = ['-', '-.', '--', ':', '-.', '-', '-', '-.', '--', ':', '-.', '-']
markers = ['o', '*', 'd', 'v', 'P', '1', 'p', 'X']
colors = ['tab:blue', 'tab:red', 'tab:green', 'tab:brown',  'tab:purple', 'tab:gray',
          'tab:olive', 'tab:cyan']

mu = 1e-4
experiment = "CompareMethods"
pwork = 1.0
method = "SAGA"

datasets = [ "mushrooms", "a1a", "phishing", "duke", "madelon", "gisette_scale","a8a" ]

T_dict = {"a1a": 5, "mushrooms": 12, "w2a": 10, "phishing": 11, "duke": 4, "madelon": 50, "gisette_scale": 100, "w7a": 4, "a8a": 8}

vrs = ["full", "partial", "none"]
Amethods = ["random","same"]
labels2 = ["L2SGD+", "L2SGD2", "L2SGD"]
labels = labels2.copy()
labels.extend(["Hom " + v for v in labels2])


# characterization of the problem
for dataset in datasets:
    print("#############################")
    print(dataset)
    print("#############################")

    T = T_dict[dataset]
    pagg = 0.1
    omega = pagg/(1-pagg)/T
    Flist = []
    Xlist = []

    A, b = get_data(dataset)
    A = normalize_data(A)

    n, d = A.shape
    K = int(1000 * n / T)
    skip_it = int(K / 500)
    v = (1 + mu) * np.ones(n)
    m = int(n / T)
    x0 = np.zeros(d)
    it = create_it(T=K, skip_it=skip_it, tau=T)

    if m * T != n:
        continue

    alpha = get_stepsize_saga(v=np.ones(n), p=np.ones(n) / m, pagg=pagg, pwork=pwork, omega=omega, n=n, T=T, mu=mu)

    if not plot_only:
        for Amethod in Amethods:
            A, b = rearrange_data(A, method=Amethod, b=b)
            f, g = make_fg_logreg(A, b, mu)
            def total_loss(X): return objective(f, psi_func, X, m, omega)
            for vr in vrs:
                print("&&&&&&&&&&&&&&&&&&&&&&&&&&&")
                print("alpha = {}, vr = {}, AM = {}".format(alpha, vr, Amethod))
                print("&&&&&&&&&&&&&&&&&&&&&&&&&&&")
                F, X, _ = vr_lgd(total_loss, g, alpha, d, K, T, m, pagg, omega, method="SAGA", psvrg=0, skip_it=skip_it, track_agg=False, vr=vr)
                Flist.append(F)
                Xlist.append(X)

        # save F
        for backup in [True, False]:
            filename = createfilename(experiment, dataset, T, omega, mu, pwork, method, backup)
            pickle_out = open(filename, "wb")
            pickle.dump((Flist, Xlist), pickle_out)
            pickle_out.close()

    # load F
    Flist, Xlist = load_pickle(experiment, dataset, T, omega, mu, pwork, method)
    it_list = [it/n for i in Flist]

    # plot
    groups = [[0,1,2], [3,4,5]]

    visualize(Flist, it_list, "method_exp_epoch", dataset, labels, linestyles=linestyles, markers=markers,
              colors=colors, groups=groups)

