







def get_parameters():
    eigvals = np.linalg.eigvals(A.T @ A)
    return (1 / n * np.max(eigvals), 1 / n * np.min(eigvals))



def grad_f(x, A, y):
    return (np.multiply(A.T, (A @ x) - y))


def grad_f_wrapper(t):
    global A, y
    return grad_f(x[t, :], A[t, :], y[t])


def distance(x):
    global x0, x_opt
    return np.linalg.norm(x - x_opt, 'fro') / np.linalg.norm(x0 - x_opt, 'fro')



def create_plot(dist, last_epoch, label):
    plt.plot(dist[1:last_epoch], label=label)
    plt.semilogy()
    plt.xlabel("Number of steps")
    plt.ylabel("Relative distance to optimum")
    plt.title("Ridge regression, n={}, d={}, regularizer={}".format(n, d, reg))
    plt.legend()
    return None





# # deleted stuff
# def grad_f(x):
#     return np.zeros(d)
#
# def grad_psi(x):
#     return np.zeros(d)
#
# def g(p_agg, omega, J, Psi):
#     r = np.random.uniform(0, 1)
#     if r < p_agg:
#         return 1 / p_agg * (omega * grad_psi(x) - Psi) + J + Psi
#     else:
#         return 1 / (1 - p_agg) * (grad_f(x) - J) + J + Psi
#
#
# def update_control(x, p_agg, J, Psi, omega):
#     r = np.random.uniform(0, 1)
#     if r < p_agg:
#         return (J, omega * grad_psi(x))
#     else:
#         return (grad_f(x), Psi)
#
# def step(x, alpha, p_agg, omega, J, Psi):
#     return x - alpha * g(p_agg, omega, J, Psi)

