#! /bin/bash

#SBATCH --gres=gpu:1
#SBATCH --cpus-per-task 2
#SBATCH --mem=12G
#SBATCH --partition gpu
#SBATCH --time=144:00:00

TARGET="/scratch/scratch_volume1/paper_authors/$(date +%Y%m%d)/force_regression/${SLURM_JOB_ID}"
mkdir -p "${TARGET}"
cd "$TARGET"

batch_size=16
dim=32
blocks=6
nonlinearity=1
residual=1
value_norm=layer
epochs=50000
molecule=$1
seed=$2

python -m flowws.run -d dump_filename "dump.$(date +%Y%m%d%H%M%S).sqlite" \
       InitializeTF \
       MD17 --seed $seed -c /scratch/scratch_volume1/paper_authors/data/md17 --n-train 1000 --n-val 1000 --y-scale-reduction 4 -m $molecule \
       MoleculeForceRegression -n $dim -m concat -j concat --n-blocks $blocks --block-nonlinearity $nonlinearity --residual $residual --activation swish --final-activation swish --dropout 0 --value-normalization $value_norm --dilation 2 \
       flowws_keras_experimental.Train -e $epochs --batch-size $batch_size --summarize 1 --validation-split 0 --seed $((seed+1)) --reduce-lr 1000 --reduce-lr-factor .8 --early-stopping 2500 --early-stopping-best 1 \
       Save -s 1 -f $molecule $seed
