#! /bin/bash

#SBATCH --gres=gpu:1
#SBATCH --cpus-per-task 2
#SBATCH --mem=12G
#SBATCH --partition gpu
#SBATCH --time=96:00:00

TARGET="/scratch/scratch_volume1/paper_authors/$(date +%Y%m%d)/inverse_coarse_graining/${SLURM_JOB_ID}"
mkdir -p "${TARGET}"
cd "$TARGET"

batch_size=64
epochs=800
dim=$1
seed=$2

python -m flowws.run -d dump_filename "dump.$(date +%Y%m%d%H%M%S).zip" \
       InitializeTF \
       PDBCache --cache-directory /scratch/scratch_volume1/paper_authors/data/pdb --records 3X0J 3X2L 3X32 4TKJ 5WQR 6EQE 6ETK 6FJN 6IIP 6JGJ 6Q01 6RYG 6SAY 6XVM 6Y5S 6YK4 6YP6 7A5M 7K4T \
       PDBCoarseGrained --neighborhood-size 12 --batch-size $batch_size --validation-fraction 0 --seed $seed --randomly-rotate 1 \
       PDBInverseCoarseGrainTransformer --n-dim $dim --n-blocks-coarse 2 --n-blocks-fine 2 \
       flowws_keras_experimental.Train -e $epochs --batch-size $batch_size --summarize 1 --validation-split 0.3 --seed $((seed+1)) --reduce-lr 20 --reduce-lr-factor .75 --early-stopping 50 --generator-train-steps 512 --generator-val-steps 512 --use-multiprocessing 0 \
       flowws_keras_experimental.Save -s 1 -f $seed $dim
