## this file contains the path mapping from experiement to the
## actual path

import os

EXPERIMENT_DIR = {
    'dataset-method-epc': '',

    #caltech
    'caltech-baseline-0.1':
}

num_aug = {
    'baseline': 0,
    'dafusion': 10,
    'randaug': 0,
    'uniform': 10,
    'search0.001': 10,
    'fixed': 10,
    'search0.0001': 10,
    'search0.01': 10
}

tag_aug = {
    'baseline': 'd',
    'dafusion': 'dt',
    'randaug': 'dr',
    'uniform': 'da(uniform)',
    'search0.001': 'da(search)',
    'fixed': 'da(fixed)',
    'search0.0001': 'da(search)',
    'search0.01': 'da(search)',
}

ROOT = 'PATH/code/autodiff/autodiff'

def get_exp_results(dataset, examples_per_class, method):
    m = num_aug[method]
    tag = tag_aug[method]
    results_file = f'results_s7_e{examples_per_class}_m{m}_p0.5_{tag}.csv'
    exp_key = f'{dataset}-{method}-{examples_per_class}'
    if EXPERIMENT_DIR[exp_key] == '':
        return ''
    full_path = os.path.join(ROOT, EXPERIMENT_DIR[exp_key], results_file)
    return full_path

def get_search_history(dataset, examples_per_class, rf, lr):
    search_key = f'search{lr}'
    results_file = f'history_s7_e{examples_per_class}_rf{rf}_searchlr{lr}_da(search).csv'
    exp_key = f'{dataset}-{search_key}-{examples_per_class}'
    full_path = os.path.join(ROOT, EXPERIMENT_DIR[exp_key], results_file)
    return full_path
