function [sel_cens] = exhaustive_search(dists,svar,k,cens)
% Exhaustive search algorithm to convert a pseuso-solution to a solution.
par_num = 100000;
if length(cens) <= k
    sel_cens = cens;
    return
end
min_val = inf;
sel_cens = cens(1:k);
groups = unique(svar);
if k < 21
    ktemp = length(cens);
else
    ktemp = length(cens) - 11;
end

for p = 0:(length(cens) - ktemp)
    if p + ktemp < k
        continue;
    end
    ksubs_num_temp = 1;
    if p > 0
        ksubs_temp = nchoosek((ktemp+1):length(cens),p);
        ksubs_num_temp = size(ksubs_temp, 1);
    end
    ksubs_temp2 = zeros(nchoosek(ktemp, k-p), k);
    ksubs_temp2(:, 1:(k-p)) = nchoosek(1:ktemp,k-p);
    ksubs_num_temp2 = size(ksubs_temp2, 1);
    for i = 1:ksubs_num_temp
        if p > 0
            ksubs_temp2(:, (k-p+1):k) = repmat(ksubs_temp(i, :), [size(ksubs_temp2, 1), 1]);
        end
        for j = 1:ceil(ksubs_num_temp2 / par_num)
            disp(strcat('p: ', num2str(p), '/', num2str(length(cens) - ktemp),' - i: ', num2str(i), '/', num2str(ksubs_num_temp), ' - j: ', num2str(j), '/', num2str(ceil(ksubs_num_temp2 / par_num))))
            sind = (j - 1) * par_num + 1;
            eind = min(j * par_num, ksubs_num_temp2);
            par_num_t = eind - sind + 1;
            col_ind = reshape(ksubs_temp2(sind:eind, :)', [1,par_num_t*k]);
            group_costs = zeros(par_num_t, length(groups));
            for l = 1:length(groups)
                group_costs(:, l) = mean(min(reshape(dists(svar==groups(l), cens(col_ind)), [sum(svar==groups(l)), k, par_num_t]), [], 2));
            end
            max_costs = max(group_costs, [], 2);
            [sub_min_val, sub_min_ind] = min(max_costs);
            if min_val > sub_min_val
                min_val = sub_min_val;
                sel_cens = cens(ksubs_temp2((j - 1) * par_num + sub_min_ind, :));
            end
        end
    
    end
end

end