function [sel_cens] = other_bicriteria(dists,svar,k,eps)
% Abbasi-Bhaskara-Venkatasubramanian bicriteria algorithm.

numPoints = size(dists, 1);
[~, x, ~] = originalLP(dists,svar,k);
Rs = sum(dists .* x, 2);
maxr = max(Rs)+1;
sel_cens = zeros(1, floor(k/(1-eps)));
T = ones(numPoints,1);
for i = 1:length(sel_cens)
    if sum(T) == 0
        break
    end
    [temp, tempi] = min(Rs + maxr * (T == 0));
    sel_cens(i) = tempi;
    T(dists(:,tempi) <= 2*temp/eps) = 0;
end

end