function [sel_cens] = other_exact(dists,svar,k,gamma)
% Makarychev-Vakilian algorithm that gives k centers and log/loglog approx.

numPoints = size(dists, 1);
[obj, ~, ~] = originalLP(dists,svar,k);
groups = unique(svar);
max_dist = max(max(dists)) + 1;
for t=2:6
    z = obj * 2^t;
    [obj, x, y] = sparsifiedLP(dists,svar,k,z);
    demands = ones(numPoints,length(groups));
    for i = 1:length(groups)
        demands(:,i) = svar == groups(i);
    end
    Rs = sum(dists .* x, 2);
    [Rsorted,Rinds] = sort(Rs);
    for i = 1:(numPoints-1)
        for j = (i+1):numPoints
            if dists(Rinds(i),Rinds(j)) <= 2 * Rsorted(j) / gamma
                demands(Rinds(i),:) = demands(Rinds(i),:) + demands(Rinds(j),:);
                demands(Rinds(j),:) = 0;
            end
        end
    end
    pprime = any(demands,2);
    for i = 1:length(y)
        if y(i) == 0 || pprime(i) == 1
            continue
        end
        [~,ind] = min(dists(:,i) .* pprime + (1-pprime) .* max_dist);
        y(ind) = min(1,y(ind)+y(i));
        y(i) = 0;
        x(:,ind) = x(:,ind) + x(:,i);
        x(:,i)=0;
    end
    pprime_inds = find(pprime);
    ind_arr = zeros(length(pprime_inds).^2,2);
    for i=1:length(pprime_inds)
        for j=1:length(pprime_inds)
            ind_arr((i-1)*length(pprime_inds) + j, 1) = pprime_inds(j);
            ind_arr((i-1)*length(pprime_inds) + j, 2) = pprime_inds(i);
        end
    end
    reshaped_pprime = reshape(dists(pprime==1,pprime==1), length(pprime_inds).^2,1);
    [~,pprime_sorted_inds] = sort(reshaped_pprime);
    parents = zeros(numPoints,1);
    for i=1:length(pprime_sorted_inds)
        if ind_arr(pprime_sorted_inds(i),1)==ind_arr(pprime_sorted_inds(i),2)
            continue
        end
        if parents(ind_arr(pprime_sorted_inds(i),1)) ~= 0
            continue
        end
        parents(ind_arr(pprime_sorted_inds(i),1)) = ind_arr(pprime_sorted_inds(i),2);
    end
    Ps = (1-y)/gamma;
    Ptoks = zeros(numPoints,1);
    Ptoks(pprime_inds(1)) = 1;
    Ptoks_temp = Ptoks;
    while all(Ptoks) == false
        Ptoks = Ptoks_temp;
        for i=1:numPoints
            if Ptoks_temp(i) ~= 0 || pprime(i) == 0 || Ptoks_temp(parents(i)) == 0
                continue
            end
            Ptoks_temp(i) = 3 - Ptoks_temp(parents(i));
        end
        if isequal(Ptoks,Ptoks_temp)
            if isequal(Ptoks~=0,pprime~=0)
                break
            else
                temp = find(Ptoks==0 & pprime~=0);
                Ptoks_temp(temp(1)) = 1;
            end
        end
    end
    if sum(Ps(Ptoks==1)) >= (sum(pprime) - k) / (2*gamma)
        sset = find(Ptoks==1);
        sset_inds = Ptoks==1;
    else
        sset = find(Ptoks==2);
        sset_inds = Ptoks==2;
    end
    if sum(pprime) <= k
        sel_cens_temp = find(pprime)';
    else
        fix_cens = find(pprime & (sset_inds == 0));
        while true
            random_cens = zeros(numPoints,1);
            for i = 1:length(sset)
                if rand() <= 1-Ps(sset(i))
                    random_cens(sset(i))=1;
                end
            end
            temp_cens = [fix_cens;find(random_cens)];
            if length(temp_cens) <= k
                sel_cens_temp = temp_cens';
                break
            end
        end
    end
    if t == 2
        sel_cens = sel_cens_temp;
    else
        prev_obj = 0;
        curr_obj = 0;
        for s = 1:length(groups)
            prev_obj = max(prev_obj,sum(min(dists(svar==groups(s),sel_cens),[],2)) / sum(svar==groups(s)));
            curr_obj = max(curr_obj,sum(min(dists(svar==groups(s),sel_cens_temp),[],2)) / sum(svar==groups(s)));
        end
        if curr_obj < prev_obj
            sel_cens = sel_cens_temp;
        end
    end
end
end