function [obj, x, y] = sparsifiedLP(dists,svar,k,z)
% Sparsified LP of Makarychev-Vakilian.

lambda=2;
numPoints = size(dists, 1);
numCenters = size(dists, 2);

groups = unique(svar);
groupNums = zeros(length(groups), 1);
groupIndics = zeros(numPoints, length(groups));
for i = 1:length(groups)
    groupIndics(:,i) = svar == groups(i);
    groupNums(i) = sum(groupIndics(:,i));
end
delta = zeros(numPoints,1);
for i=1:numPoints
    this_dists = sort(dists(i,:));
    for j = 1:numCenters
        if j * this_dists(j) >= z
            delta(i) = z / (j-1);
            break
        end
    end
end

obj = optimvar('lambda');
centerVars = optimvar('y',[numCenters,1],'LowerBound',0.0,'UpperBound',1.0);
connectionVars = optimvar('x',[numPoints, numCenters],'LowerBound',0.0,'UpperBound',1.0);

prob = optimproblem('Objective',obj,'ObjectiveSense','min');

prob.Constraints.c1 = connectionVars * ones(numCenters, 1) == 1;
prob.Constraints.c2 = sum(centerVars) <= k;

prob.Constraints.connectionConstraints = connectionVars <= repmat(centerVars', numPoints, 1);
groupConstraints = optimconstr(length(groups),1);
for i = 1:length(groups)
    groupConstraints(i) = sum(sum(dists .* groupIndics(:,i) .* connectionVars / groupNums(i))) <= obj;
end
prob.Constraints.groupConstraints = groupConstraints;

prob.Constraints.sparsificationConstraints = (dists > repmat(lambda * delta,1,numCenters)) .* connectionVars == zeros(numPoints,numCenters);

problem = prob2struct(prob);

[sol,~,~,~] = cplexlp(problem);
obj = sol(1);
x = reshape(sol(2:end-numCenters), numPoints, numCenters);
y = sol(end-numCenters+1:end)';

end

