import numpy as np

def reward_func(observations):
    """Computation of the reward from the observations of the safety-gym-CarGoal-v0 env.

    The observations are also the ones predicted by the model.
    For compatibility with other environments the actions should be appended to
    the inputs observations as the reward can be a function of both the actions
    and the observations.

    The  reward  is in [0, 1]

    Parameters
    ----------
    observations : array, shape (n_samples, n_observations + n_actions)
        Observations and actions. The last feature is the action, which is not
        used here but put for compatibility with other environments.
        Note that this is the action leading to the obtained observations.

    Return
    ------
    reward : float
        Reward.
    """
    # The goal distance returned in the observations is inversely proportional to the real goal dist.
    # This means, the higher the obs_goal_dist, the closer we are to the goal.
    # For this reason we invert it to return to the real goal distance

    dist_goal = observations[:, 5]

    return dist_goal