# Made by: Giuseppe PAOLO
# Date: 4/8/2022

import numpy as np


def safety_function(observations):
    """
    This function returns 1 if the state is unsafe and 0 if safe
    """
    angle = np.arctan2(observations[:, 1], observations[:, 0])
    unsafe_min_angle = np.pi * (20. / 180)  # 20 degree converted in rad
    unsafe_max_angle = np.pi * (30. / 180)  # 30 degree converted in rad

    return np.logical_and(unsafe_min_angle < angle, angle < unsafe_max_angle).astype(np.float)