import click
from .leaderboard import long_horizon_stats

import cloudpickle

import numpy as np

from rampwf.utils import assert_read_problem
from rampwf.utils.importing import import_module_from_source

from mbrltools.model_env import make_model_env_class


CONTEXT_SETTINGS = dict(help_option_names=['-h', '--help'])


@click.command(context_settings=CONTEXT_SETTINGS)
@click.option('--model', help='The model')
@click.option('--agent', help='The agent.')
@click.option('--seed', help='The seed.')
@click.option('--horizon', default=20, show_default=True,
              help='The horizon up to which we generate stats.')
@click.option('--n-traces', default=200, show_default=True,
              help='The number of traces we use to generate stats.')
def long_horizon_stats_command(model, agent, seed, horizon=20, n_traces=200):
    """Simulate random traces from learned generative models and save stats.

    Run this from the benchmarks/<env> folder. Stats are saved in
    submissions/<model>/mbrl_output/<agent>/seed_<seed>/stats_and_figs/
    All three files (errors, stds, ranks) have the same columns:
    epoch_id, <timestamp_name>, <timestamp_name>_ahead
    where timestamp_name is from metadata or `time_step` if metadata has ``
    followed by the columns defined in the obss variable in 
    stats_and_figs.py in the env folder.
    """
    long_horizon_stats(model, agent, seed, horizon, n_traces)

if __name__ == "__main__":
    long_horizon_stats_command()
