EXP_NAME=$1
mkdir decode

for idx in 5258 10516 15774 21032 26289; do
    CUDA_VISIBLE_DEVICES=0 python -m torch.distributed.launch --nproc_per_node=1 \
        src/gpt2_beam.py \
        --data data/e2e/test.jsonl \
        --batch_size 4 \
        --seq_len 512 \
        --eval_len 64 \
        --model_card gpt2.md \
        --init_checkpoint results/$EXP_NAME/model.${idx}.pt \
        --platform local \
        --lora_dim 0 \
        --lora_alpha 32 \
        --beam 10 \
        --length_penalty 0.8 \
        --no_repeat_ngram_size 4 \
        --repetition_penalty 1.0 \
        --eos_token_id 628 \
        --work_dir results/$EXP_NAME \
        --output_file predict.${idx}.b10p08r4.jsonl

    python src/gpt2_decode.py \
        --vocab ./vocab \
        --sample_file results/$EXP_NAME/predict.${idx}.b10p08r4.jsonl \
        --input_file data/e2e/test_formatted.jsonl \
        --output_ref_file decode/${EXP_NAME}_${idx}_e2e_ref.txt \
        --output_pred_file decode/${EXP_NAME}_${idx}_e2e_pred.txt
done