Source: https://github.com/tsoumakas/mulan/tree/master/data/multi-target

# Datasets
Mulan was extended for multi-target regression (MTR). Below you can find a list of benchmark MTR datasets that we have collected along with the corresponding sources and citations. For more details on each dataset see the corresponding paper(s). All datasets can be downloaded from here!

## Statistics 
| name | examples | features | targets | Source/Citation | 
| ---- | -------- | -------- | ------- | --------------- |
| [atp1d](https://github.com/tsoumakas/mulan/tree/master/data/multi-target/atp1d.arff) | 337 | 411 | 6 | [1] |
| [atp7d](https://github.com/tsoumakas/mulan/tree/master/data/multi-target/atp7d.arff)	| 296 | 411	| 6	| [1] |
| [oes97](https://github.com/tsoumakas/mulan/tree/master/data/multi-target/oes97.arff)	| 334 | 263 | 16 | [1] |
| [oes10](https://github.com/tsoumakas/mulan/tree/master/data/multi-target/oes10.arff) | 403 | 298 | 16 | [1] |
| [rf1](https://github.com/tsoumakas/mulan/tree/master/data/multi-target/rf1.arff) | 9125 | 64 | 8 | [1] |
| [rf2](https://github.com/tsoumakas/mulan/tree/master/data/multi-target/rf2.arff) | 9125 | 576 | 8 | [1] |
| [scm1d](https://github.com/tsoumakas/mulan/tree/master/data/multi-target/scm1d.arff)	| 9803 | 280 | 16 | [1] |
| [scm20d](https://github.com/tsoumakas/mulan/tree/master/data/multi-target/scm20d.arff) | 8966 | 61 | 16 | [1] |
| [edm](https://github.com/tsoumakas/mulan/tree/master/data/multi-target/edm.arff) | 154 | 16 | 2 | [2] |
| [sf1](https://github.com/tsoumakas/mulan/tree/master/data/multi-target/sf1.arff) | 323 | 10 | 3 | [3] |
| [sf2](https://github.com/tsoumakas/mulan/tree/master/data/multi-target/sf2.arff) | 1066 | 10 | 3 | [3] |
| [jura](https://github.com/tsoumakas/mulan/tree/master/data/multi-target/jura.arff) | 359 | 15 | 3 | [4],[1] |
| [wq](https://github.com/tsoumakas/mulan/tree/master/data/multi-target/wq.arff) | 1060 | 16 | 14 | [5] |
| [enb](https://github.com/tsoumakas/mulan/tree/master/data/multi-target/enb.arff) | 768 | 8 | 2 | [6], [1] |
| [slump](https://github.com/tsoumakas/mulan/tree/master/data/multi-target/slump.arff) | 103 | 7 | 3 | [7], [1] |
| [andro](https://github.com/tsoumakas/mulan/tree/master/data/multi-target/andro.arff)	| 49 | 30 | 6 | [8], [1] |
| [osales](https://github.com/tsoumakas/mulan/tree/master/data/multi-target/osales.arff) | 639 | 413 | 12 | [9], [1] |
| [scpf](https://github.com/tsoumakas/mulan/tree/master/data/multi-target/scpf.arff) | 1137 | 23 | 3 | [10], [1] |

## Sources / Citations
1. E. Spyromitros-Xioufis, G. Tsoumakas, W. Groves, I. Vlahavas, "Multi-Target Regression via Input Space Expansion: Treating Targets as Inputs", Machine Learning, 2016. [paper](http://link.springer.com/article/10.1007%2Fs10994-016-5546-z)[bibtex](http://users.auth.gr/espyromi/publications/bibtex/spyromitros2016mlj.bib)
2. A. Karalic, I. Bratko, "First Order Regression", Machine Learning, 1997.
3. [UCI repository](http://archive.ics.uci.edu/ml/datasets/Solar+Flare)
4. Gooaverts P., "Geostatistics for natural resources evaluation", Oxford university press, 1997.
5. S. Dzeroski, D. Demsar, J. Grbovic, "Predicting Chemical Parameters of River Water Quality from Bioindicator Data", Applied Intelligence, 2000.
6. A. Tsanas, A. Xifara, "Accurate quantitative estimation of energy performance of residential buildings using statistical machine learning tools", Energy and Buildings, 2012.
7. IC. Yeh, "Modeling slump flow of concrete using second-order regressions and artificial neural networks", Cement and Concrete Composites, 2007.
8. EV. Hatzikos, "An empirical study on sea water quality prediction", Knowledge-based systems, 2008.
9. [Kaggle competition: Online Product Sales](https://www.kaggle.com/c/online-sales)
10. [Kaggle competition: See Click Predict Fix](https://www.kaggle.com/c/see-click-predict-fix)