# Linearly Alignable OT

## Important points in the code

### Parts of the AE framework
Those parts are the general reusable components of the AE.
Ideally you should not have to modify those even when creating new experiments.

- `global_config.py`: Here one needs to specifiy the dataset directory and the output directory
to store trained models
- `dataloader/`: This directory you can find the custom dataloader used with the parameters 
defined in `aeconfig.py` files.
- `utils/model.py`: This file contains the definition of a model. A model is defined by
a ae architecture and dataset parameters. It provides housekeeping, saving and loading functions,
as well as functions to plot the reconstructions stored in the model's housekeeping data.
- `utils/ot_functions.py`: This file contains the ot functions used to compute the affinity score.
It's basically a modified version of Karol and Antons code working with pytorch tensors.
- `network/coupledAE.py`: This file contains the coupled ae model
and is a modified version of a AE that trains two AEs in parallel. It also computes the test
performance and stores the latent representations at each epoch.
- `network/train_functions_global.py`: This file contains function to compute for example 
reconstruction loss or affinity loss which can be re-used in experiment specific train function
definitions.

### Configuring an experiment
Experiments are defined in folders. For example features\_ae is the experiment 
with the ball dataset.
In `features_ae/aeconfig.py` you can change all important parameters for the experiment.

### Examples
#### Changing the encoder decoder input dimensionality
In order to do this you would go to the vaeconfig.py of the experiment you want to modify.
In the function `setup_network()` you can change the type of encoder 
(for example from EncoderConv to EncoderFC or your own classes) and its input parameters.

## Usage 
Train a model using
```
python train_AE.py --a [alpha] --z [latent dimenstion for both AEs] --e [train epcohs] --lr [learning_rate] --x '[experiment]' --d1 [domain1] --d2 [domain2] 
                    --f1 [features1] --f2 [features2] --pc [number of labelled points per class] --hid1 [size of the hidden layer of source AE] --hid2 [size of the hidden layer of target AE] 
                    --b1 [Batch size for source AE] --b2 [Batch size for target AE] "
```

For example:
```
python train_AE.py --a 1.0 --b 0.0 --z 10 --e 20 --x 'features_ae' --d1 'amazon' --d2 'caltech10' --f1 'CaffeNet4096' --f2 'CaffeNet4096' --pc 0 --hid1 2048 --hid2 2048 --b1 64 --b2 64
```

The models will be stored in the models folder specified in `global_config.py` in a subfolder 
called `[experiment]/[setup]/model.pkl`
