def merge_dicts(dicts):
    return {
        k: v
        for d in dicts
        for k, v in d.items()
    }


def exec_safe(code_str, gvars=None, lvars=None):
    banned_phrases = ['import', '__']
    for phrase in banned_phrases:
        assert phrase not in code_str

    if gvars is None:
        gvars = {}  # GLOBAL VARIABLES
    if lvars is None:
        lvars = {}  # LOCAL VARAIBALES: ROBOT ACTIONS
    empty_fn = lambda *args, **kwargs: None
    custom_gvars = merge_dicts([
        gvars,
        {'exec': empty_fn, 'eval': empty_fn}
    ])
    exec(code_str, custom_gvars, lvars)


def get_robot_action_list(robot_api):
    # TODO: Need a better way to mark functions to ignore/not ignore in the RobotActionAPI class
    fn_to_ignore = ["_initialize", "initialize", "stop", "reset", "safe_append_completed_subtask"]
    return [k for k in dir(robot_api) if "__" not in k and k not in fn_to_ignore and callable(getattr(robot_api, k))]