
# the following code is from the original eigenscore repo: https://github.com/D2I-ai/eigenscore/tree/main

import numpy as np
import torch
import torch.nn.functional as F
from sklearn.covariance import MinCovDet
from rouge_score import rouge_scorer
from sentence_transformers import util
import heapq


def getSentenceSimilarity(generations, answers, SenSimModel):
    gen_embeddings = SenSimModel.encode(generations)
    ans_embeddings = SenSimModel.encode(answers)
    similarity = util.cos_sim(gen_embeddings, ans_embeddings)
    return similarity.item()


def get_perplexity_score(scores):
    perplexity = 0.0
    for logits in scores:
        conf = torch.max(logits.softmax(1)).cpu().item()
        perplexity += np.log(conf)
    perplexity = -1.0 * perplexity/len(scores)
    return perplexity



def get_energy_score(scores):
    avg_energy = 0.0
    for logits in scores:
        energy = - torch.logsumexp(logits[0], dim=0, keepdim=False).item()
        avg_energy += energy
    avg_energy = avg_energy/len(scores)
    return avg_energy




def get_entropy_score(batch_scores, num_tokens):  
    Conf = []
    for logits in batch_scores: 
        conf, index = torch.max(logits.softmax(1), dim=1)
        Conf.append(conf.cpu().numpy())
    Conf = np.array(Conf) 
    Conf = Conf + 1e-6
    entropy = -1.0 * np.sum(np.log(Conf))/logits.shape[0]
    return entropy



def get_lenghthNormalized_entropy(batch_scores, num_tokens):  
    seq_entropy = np.zeros(len(num_tokens))  ## 保存每个seq的log(p)乘积
    for ind1, logits in enumerate(batch_scores): 
        for ind2, seq_logits in enumerate(logits):
            if ind1 < num_tokens[ind2]:
                conf, _ = torch.max(seq_logits.softmax(0), dim=0)
                seq_entropy[ind2] = seq_entropy[ind2] + np.log(conf.cpu().numpy())
    normalized_entropy = 0
    for ind, entropy in enumerate(seq_entropy):
        normalized_entropy += entropy/num_tokens[ind]
    normalized_entropy = -1.0* normalized_entropy/len(num_tokens)
    return normalized_entropy



def getLexicalSim(generated_texts):
    LexicalSim = 0
    for i in range(len(generated_texts)):
        for j in range(len(generated_texts)):
            if j<=i:
                continue
            LexicalSim += getRouge(rougeEvaluator, generated_texts[i], generated_texts[j])
    LexicalSim = LexicalSim/(len(generated_texts)*(len(generated_texts)-1)/2)
    return LexicalSim



# output eigenscore
def getEigenIndicatorOutput(generated_texts, SenSimModel):
    alpha = 1e-3
    _embeddings = []
    for ind in range(len(generated_texts)):
        embeddings = SenSimModel.encode(generated_texts[ind])
        _embeddings.append(embeddings)
    _embeddings = np.array(_embeddings)
    CovMatrix = np.cov(_embeddings)
    CovMatrix = CovMatrix + alpha*np.eye(CovMatrix.shape[0])
    u, s, vT = np.linalg.svd(CovMatrix)
    eigenIndicatorOutput = np.mean(np.log10(s))
    return eigenIndicatorOutput, s



# original eigenscore
def getEigenIndicator_v0(hidden_states, num_tokens): 
    alpha = 1e-3
    selected_layer = int(len(hidden_states[0])/2)
    # selected_layer = -1
    if len(hidden_states)<2:
        return 0, "None"
    last_embeddings = torch.zeros(hidden_states[1][-1].shape[0], hidden_states[1][-1].shape[2]).to("cuda")
    for ind in range(hidden_states[1][-1].shape[0]):
        last_embeddings[ind,:] = hidden_states[num_tokens[ind]-2][selected_layer][ind,0,:] 
    CovMatrix = torch.cov(last_embeddings).cpu().numpy().astype(float)
    u, s, vT = np.linalg.svd(CovMatrix+alpha*np.eye(CovMatrix.shape[0]))
    eigenIndicator = np.mean(np.log10(s))
    return eigenIndicator, s

# variant eigenscore 

###### hidden_states : (num_tokens, num_layers, num_seq, num_input_tokens/1, embedding_size)
def getEigenIndicator_v2(hidden_states, num_tokens):
    alpha = 1e-3
    LayerEigens = []
    if len(hidden_states) < 2:
        return 0

    last_s = None  # keep the most recent singular values to return like before

    for layer_ind in range(len(hidden_states[0])):
        # build mean embedding per sequence (unchanged logic)
        last_embeddings = torch.zeros(
            hidden_states[1][-1].shape[0],
            hidden_states[1][-1].shape[2],
            device="cuda",
        )
        for seq_ind in range(hidden_states[1][-1].shape[0]):
            for token_ind in range(len(hidden_states) - 1):
                if token_ind > num_tokens[seq_ind] - 1:
                    continue
                last_embeddings[seq_ind, :] += hidden_states[token_ind + 1][layer_ind][seq_ind, 0, :]
            # NOTE: keep original denominator (may be zero/negative if inputs are off)
            last_embeddings[seq_ind, :] = last_embeddings[seq_ind, :] / (num_tokens[seq_ind] - 1)

        # cov -> numpy (unchanged math)
        CovMatrix = torch.cov(last_embeddings)
        Cov_np = CovMatrix.detach().cpu().numpy().astype(float)

        # quick sanity check: if the matrix is numerically bad, return NaN instead of crashing
        if not np.isfinite(Cov_np).all():
            return float("nan")

        # SVD with defense: return NaN if it doesn't converge
        try:
            u, s, vT = np.linalg.svd(Cov_np + alpha * np.eye(Cov_np.shape[0]), full_matrices=False)
        except np.linalg.LinAlgError:
            return float("nan")
        except Exception:
            # catch-all to avoid unexpected hard crashes
            return float("nan")

        last_s = s
        eigenIndicator = np.mean(np.log10(s))
        LayerEigens.append(eigenIndicator)

    LayerEigens = np.array(LayerEigens)
    # averages eigenscores from layer 20 to the second-to-last layer (unchanged)
    return np.mean(LayerEigens[20:-2])




    







