
# model settings
batch_size = 256

# optimizer and learning rate
optimizer = dict(type='SGD', lr=0.01, momentum=0.9, weight_decay=5e-4)
optimizer_config = dict(grad_clip=None)
lr_config = dict(policy='step', step=[100,25])

## model dict
model_dict = dict(in_channels=3,num_classes=10,kernel_type="large")

# runtime settings
work_dir = '../res/'
gpus = range(1)
dist_params = dict(backend='nccl')
data_workers = 2  # data workers per gpu
checkpoint_config = dict(interval=50)  # save checkpoint at every epoch
workflow = [('train', 5), ('val', 1)]
total_epochs = 150  #
resume_from = None
load_from = None

# logging settings
log_level = 'INFO'
log_config = dict(
    interval=20,  # log at every 50 iterations
    hooks=[
        dict(type='TextLoggerHook'),
        # dict(type='TensorboardLoggerHook'),
    ])
