## th
# model settings
batch_size = 256

# optimizer and learning rate
optimizer = dict(type='SGD', lr=0.05, momentum=0.9, weight_decay=5e-4)
optimizer_config = dict(grad_clip=None)
lr_config = dict(policy='step', step=[100,25])

model_dict = dict(fine_model_dict = dict(times=2,num_classes=10,top_layer="IT",low_layer="V2",in_channels=3,
                  feedback_mode ="upsample_pconv_gate",),
                  coarse_model_dict = dict(in_channels=1,num_classes=10,kernel_type="large"),
                  cache_model_dict = dict(mode="average",T=0.01),
                  source_data=None,target_data=None,dataloader=None,using_cache=True,
                  finenet_type="CORnet_RT_FineliteA",coarsenet_type="CORnet_RT_Coarselite")


# runtime settings
work_dir = '../res/'
gpus = range(1)
dist_params = dict(backend='nccl')
data_workers = 2  # data workers per gpu
checkpoint_config = dict(interval=20)  # save checkpoint at every epoch
workflow = [('train', 5), ('val', 1)]
total_epochs = 150  #
resume_from = None
load_from = None

# logging settings
log_level = 'INFO'
log_config = dict(
    interval=20,  # log at every 50 iterations
    hooks=[
        dict(type='TextLoggerHook'),
        # dict(type='TensorboardLoggerHook'),
    ])
