#pragma once
#include "template/domain_dependent/evaluator_base.h"
#include "numeral211/game_numeral211.h"
#include <boost/format.hpp>

namespace numeral211{
    using Evaluator_t = Evaluator<Numeral211>;
}
template<>
class Evaluator<Numeral211> final : public EvaluatorBase<Numeral211>{
    friend EvaluatorBase<Poker_t>;
private:
    inline static const int len_2plus2 = 15593606;
    inline static int lookup_2plus2[len_2plus2];
    inline static boost::format info_format = boost::format("{\nhandType: %d,\nhandRank: %d,\nvalue: %d,\nhandName: %s\n}");
    inline const static char* hand_name[]{
        "invalid hand",
        "high card",
        "pair",
        "flush",
        "straight",
        "three of a kind",
        "straight flush"
    };
};