#pragma once
#include "overall_define.h"
#include "template/domain_independent/showdown_histogram.h"
#include <string>

template<typename Poker>
class EvaluatorBase{
protected:
    static inline bool initialized_ = false;
public:
    static inline const bool &initialized = initialized_;
    using Poker_t = Poker;
public:
    /* 有些evaluator需要进行初始化如2+2 */
    static void init();
    static void free();

    /* 评估一副手牌 */
    static type::rank_t evaluate_rank(const type::card_t hole[Poker_t::hole_len[Poker_t::num_rounds-1]], const type::card_t board[Poker_t::board_len[Poker_t::num_rounds-1]]);
    static type::rank_t evaluate_rank(const type::card_t hand[Poker_t::hand_len[Poker_t::num_rounds-1]]);

    /* 评估多副手牌 */
    static void evaluate_ranks(const type::card_t holes[Poker_t::num_players][Poker_t::hole_len[Poker_t::num_rounds-1]], const type::card_t board[Poker_t::board_len[Poker_t::num_rounds-1]], type::rank_t ranks[Poker_t::num_players]);

    /* 评估潜在胜率 */
    static ShowdownHistogram/* 负平胜*/ evaluate_potential(const type::card_t hole[Poker_t::hole_len[Poker_t::num_rounds-1]], const type::card_t board[Poker_t::board_len[Poker_t::num_rounds-1]]);
    static ShowdownHistogram evaluate_potential(const type::card_t hand[Poker_t::hand_len[Poker_t::num_rounds-1]]);

    /* 给出一副手牌信息 */
    static std::string info_rank(const type::card_t hole[Poker_t::hole_len[Poker_t::num_rounds-1]], const type::card_t board[Poker_t::board_len[Poker_t::num_rounds-1]]);
    static std::string info_rank(const type::card_t hand[Poker_t::hand_len[Poker_t::num_rounds-1]]);
};