use krwemd_rs::featurizer::Featurizer;
use krwemd_rs::game::builtin::numeral211::{self, Numeral211};
use krwemd_rs::game::component::*;
use krwemd_rs::hand_isomorphism::{hand_indexer_t, hand_unindex, uint_fast32_t};
use krwemd_rs::abstraction_cluster::*;
use std::time::Instant;

type GameType = Numeral211;

// cargo run --example generate_ehs --features "rust_waugh test_print"
fn main() {
    numeral211::game_specific::setup();
    for i in 1..=1 {
        let start = Instant::now();
        let cluster_configs = vec![
            AbstractAlgorithmStreet::Isomorphism{recall_from: 0},
            AbstractAlgorithmStreet::Ehs{ centroid_size: 225, train_iteration: 1000},
            AbstractAlgorithmStreet::Ehs{ centroid_size: 396, train_iteration: 1000},
        ];
        let abstraction = EhsCluster::<GameType>::new(cluster_configs.as_ref());
        println!("time costed: {:?}", start.elapsed());
        abstraction.save(i.to_string().as_str());
    }
}