//typedef
use std::sync::{Arc, Mutex};
use std::cell::RefCell;
use crate::database::db_type::{WinDistType, RWDist};

////////////////////////////////////////////////////
//type define
////////////////////////////////////////////////////

#[derive(Debug)]
pub struct WinDistNode{
    pub win_dist: RWDist,       //胜率分布
    pub origin_count: i64,      //对应手牌id个数 weights
}
pub type WinDistNodePtr = Arc<WinDistNode>;

#[derive(Debug)]
pub struct WinDistCenter{
    pub centroid: Arc<WinDistNode>,                 //聚类中心
    pub point_set: Vec<Arc<WinDistNode>>,           //聚类点集
    pub centorid_diff: bool,
    //pub point_set: Mutex<Vec<Arc<WinDistNode>>>,    //聚类点集
} 
pub type WinDistCenterPtr = Arc<Mutex<WinDistCenter>>;

#[derive(Debug)]
pub struct KmeansPP {
    pub cluster_num: i32,
    pub point_set: Vec<Arc<WinDistNode>>,
    pub cluster_set: Arc<Mutex<Vec<WinDistCenterPtr>>>,
}

////////////////////////////////////////////////////
//correlation function
////////////////////////////////////////////////////
impl WinDistNode{
    pub fn new(id: i64, win_dist: WinDistType, origin_count: i64) -> Self{
        WinDistNode{
            win_dist: RWDist::new(id, win_dist),
            origin_count: origin_count,
        }
    }

    pub fn get_rwdist(&self) -> &RWDist {
        &self.win_dist
    }
}

impl WinDistCenter{
    pub fn new(centroid: Arc<WinDistNode>) -> Self {
        WinDistCenter{
            centroid: centroid.clone(),
            point_set: vec![centroid.clone()],
            centorid_diff: true,
            //point_set: Mutex::new(vec![centroid.clone()]),
        }
    }

    pub fn get_rwdist(&self) -> &RWDist {
        self.centroid.get_rwdist()
    }

    pub fn clear_pointset(& mut self) -> Result<(), String>{
        self.point_set.clear();
        Ok(())
    }
}

impl KmeansPP {
    pub fn new(cluster_num:i32, point_set :Vec<Arc<WinDistNode>>) -> Self{
        KmeansPP{
            cluster_num: cluster_num,
            point_set: point_set,
            cluster_set: Arc::new(Mutex::new(Vec::new()))
        }
    }
}